<?php if ( ! defined('ETHEME_FW')) exit('No direct script access allowed');
/**
 * Template "Engine" - step for ET_Setup_Wizard.
 * @package ET_Setup_Wizard
 * @since 9.5.0
 * @version 1.0.0
 */

?>

<div class="wizard-step wizard-engine">
	<div class="wizard-step-content">
        <div class="wizard-step-heading">
            <h2 class="text-center"><?php echo esc_html__('Preferred page builder', 'xstore'); ?></h2>
            <p class="text-center"><?php echo esc_html_e('Select one of the page builders below.', 'xstore'); ?></p>
        </div>
        <div class="engine-selectors container-mini">
            <input type="radio" id="elementor" name="engine" value="elementor" checked>
            <label class="engine-selector text-center active" for="elementor">
                <div class="text-uppercase" style="font-size: .85em"><?php echo esc_html_e('Page builder', 'xstore'); ?></div>
                <svg width="192" height="40" viewBox="0 0 192 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M126.344 20.2265C126.344 20.2265 124.829 20.5919 123.547 20.9003L121.599 21.3486C121.593 21.3486 121.586 21.3486 121.581 21.3486C121.581 20.8173 121.619 20.2576 121.745 19.7418C121.906 19.0809 122.26 18.3086 122.875 17.9691C123.544 17.6011 124.36 17.5571 125.068 17.8422C125.801 18.135 126.137 18.8503 126.28 19.5915C126.321 19.7988 126.347 20.0062 126.367 20.2161L126.344 20.2265ZM131.426 21.3486C131.426 16.2094 128.223 14.0013 124.132 14.0013C119.507 14.0013 116.609 17.2383 116.609 21.3746C116.609 25.871 119.076 28.7995 124.385 28.7995C127.257 28.7995 128.882 28.2863 130.816 27.3094L130.08 23.9429C128.606 24.6115 127.234 25.021 125.403 25.021C123.396 25.021 122.252 24.2513 121.819 22.8129H131.298C131.374 22.4267 131.426 21.9888 131.426 21.3486Z" fill="#92003B"/>
                    <path d="M83.809 20.2265C83.809 20.2265 82.2936 20.5919 81.0117 20.9003L79.0634 21.3486C79.0581 21.3486 79.0504 21.3486 79.0453 21.3486C79.0453 20.8173 79.0839 20.2576 79.2093 19.7418C79.3709 19.0809 79.7248 18.3086 80.34 17.9691C81.0093 17.6011 81.8245 17.5571 82.5322 17.8422C83.2654 18.135 83.6013 18.8503 83.7449 19.5915C83.7859 19.7988 83.8114 20.0062 83.8319 20.2161L83.809 20.2265ZM88.8903 21.3486C88.8903 16.2094 85.6881 14.0013 81.5964 14.0013C76.9714 14.0013 74.0742 17.2383 74.0742 21.3746C74.0742 25.871 76.5406 28.7995 81.8501 28.7995C84.7217 28.7995 86.347 28.2863 88.2801 27.3094L87.5445 23.9429C86.0701 24.6115 84.6985 25.021 82.8679 25.021C80.8605 25.021 79.717 24.2513 79.2839 22.8129H88.7623C88.8392 22.4267 88.8903 21.9888 88.8903 21.3486Z" fill="#92003B"/>
                    <path d="M72.0851 10.225H67.3906V28.2836H72.0851V10.225Z" fill="#92003B"/>
                    <path d="M132.416 14.4616H137.346L138.384 17.6545C139.033 16.0788 140.495 14.0521 143.087 14.0521C146.645 14.0521 148.576 15.8766 148.576 20.5779V28.2853H143.645C143.645 26.6786 143.648 25.0744 143.651 23.4675C143.651 22.7315 143.638 21.9955 143.648 21.2595C143.656 20.5805 143.704 19.8781 143.345 19.2691C143.102 18.857 142.705 18.5538 142.276 18.3465C141.407 17.9266 140.464 17.937 139.61 18.3879C139.4 18.4994 138.384 19.054 138.384 19.3106V28.2853H133.454V18.191L132.416 14.4616Z" fill="#92003B"/>
                    <path d="M152.303 18.0853H150.042V14.4622H152.303V12.1971L157.233 11.0231V14.4622H162.189V18.0853H157.233V22.1438C157.233 23.7377 157.995 24.4815 159.139 24.4815C160.308 24.4815 160.969 24.326 161.959 23.9943L162.543 27.7443C161.197 28.3353 159.52 28.6178 157.815 28.6178C154.231 28.6178 152.301 26.8968 152.301 23.5563V18.0853H152.303Z" fill="#92003B"/>
                    <path d="M171.415 24.6855C173.219 24.6855 174.286 23.3742 174.286 21.2698C174.286 19.1654 173.271 17.9551 171.491 17.9551C169.686 17.9551 168.646 19.1628 168.646 21.3449C168.646 23.4027 169.661 24.6855 171.415 24.6855ZM171.466 13.9225C176.091 13.9225 179.47 16.851 179.47 21.3968C179.47 25.9684 176.091 28.7181 171.415 28.7181C166.764 28.7181 163.459 25.8933 163.459 21.3968C163.459 16.851 166.738 13.9225 171.466 13.9225Z" fill="#92003B"/>
                    <path d="M112.193 14.421C111.321 14.0581 110.334 13.9234 109.39 14.0607C108.911 14.1307 108.442 14.2707 108.006 14.4884C106.811 15.0844 105.881 16.445 105.381 17.6579C105.052 16.261 104.096 15.0067 102.699 14.4236C101.827 14.0607 100.84 13.926 99.8966 14.0633C99.4173 14.1333 98.948 14.2732 98.5121 14.4909C97.3199 15.0844 96.3919 16.4398 95.8895 17.6501V17.562L94.8844 14.4676H89.9541L90.9926 18.197V28.2887H95.8895V19.2673C95.9073 19.1999 96.1253 19.0755 96.1637 19.047C96.738 18.635 97.4123 18.2099 98.1301 18.1581C98.8635 18.1037 99.5864 18.4795 100.022 19.0678C100.068 19.1326 100.112 19.1973 100.153 19.2647C100.512 19.8738 100.463 20.5761 100.456 21.2551C100.448 21.9911 100.458 22.7271 100.458 23.4632C100.456 25.07 100.453 26.6743 100.453 28.281H105.383V20.5761C105.383 20.5372 105.383 20.4984 105.383 20.4621V19.2725C105.393 19.2077 105.619 19.0781 105.66 19.0496C106.234 18.6375 106.909 18.2125 107.627 18.1607C108.36 18.1063 109.083 18.4821 109.519 19.0704C109.565 19.1352 109.608 19.1999 109.649 19.2673C110.008 19.8764 109.96 20.5787 109.952 21.2577C109.944 21.9937 109.955 22.7298 109.955 23.4658C109.952 25.0726 109.949 26.6768 109.949 28.2836H114.88V20.5761C114.88 18.3162 114.559 15.4058 112.193 14.421Z" fill="#92003B"/>
                    <path d="M191.129 14.0521C188.537 14.0521 187.078 16.0814 186.427 17.6545L185.388 14.4616H180.458L181.496 18.191V28.2828H186.427V18.9581C187.129 18.8337 190.941 19.5438 191.665 19.8107V14.0703C191.49 14.0599 191.313 14.0521 191.129 14.0521Z" fill="#92003B"/>
                    <path d="M60.3188 20.2265C60.3188 20.2265 58.8036 20.5919 57.5217 20.9003L55.5732 21.3486C55.5681 21.3486 55.5604 21.3486 55.5553 21.3486C55.5553 20.8173 55.5937 20.2576 55.7193 19.7418C55.8809 19.0809 56.2347 18.3086 56.85 17.9691C57.5191 17.6011 58.3345 17.5571 59.0422 17.8422C59.7754 18.135 60.1111 18.8503 60.2548 19.5915C60.2958 19.7988 60.3214 20.0062 60.3419 20.2161L60.3188 20.2265ZM65.4003 21.3486C65.4003 16.2094 62.1981 14.0013 58.1063 14.0013C53.4811 14.0013 50.584 17.2383 50.584 21.3746C50.584 25.871 53.0504 28.7995 58.3601 28.7995C61.2316 28.7995 62.857 28.2863 64.7901 27.3094L64.0543 23.9429C62.5801 24.6115 61.2085 25.021 59.3779 25.021C57.3705 25.021 56.227 24.2513 55.7936 22.8129H65.272C65.349 22.4267 65.4003 21.9888 65.4003 21.3486Z" fill="#92003B"/>
                    <path d="M40.252 20C40.252 31.0457 31.2977 40 20.252 40C9.20627 40 0.251953 31.0457 0.251953 20C0.251953 8.95426 9.20627 -6.10352e-05 20.252 -6.10352e-05C31.2977 -6.10352e-05 40.252 8.95426 40.252 20Z" fill="#92003B"/>
                    <path d="M5.61869 10.1595C5.61869 7.51251 7.76452 5.36667 10.4115 5.36667H30.0909C32.7379 5.36667 34.8838 7.51251 34.8838 10.1595V29.8389C34.8838 32.4859 32.7379 34.6318 30.0909 34.6318H10.4115C7.76452 34.6318 5.61869 32.4859 5.61869 29.8389V10.1595Z" fill="#92003B"/>
                    <path d="M11.5851 28.8982L11.5851 10.01H15.3627L15.3627 28.8982H11.5851Z" fill="white"/>
                    <path d="M19.1405 10.0104H30.4734V13.788H19.1405V10.0104Z" fill="white"/>
                    <path d="M19.1405 17.5652H30.4734V21.3429H19.1405V17.5652Z" fill="white"/>
                    <path d="M19.1405 25.1201H30.4734V28.8977H19.1405V25.1201Z" fill="white"/>
                </svg>
                <p>
                    <?php echo esc_html_e('Select this builder to create your site using Elementor — the most popular visual editor for WordPress.', 'xstore'); ?>    
                </p>
            </label>
            <input type="radio" id="wpb" name="engine" value="wpb">
            <label class="engine-selector text-center" for="wpb">
                <div class="text-uppercase" style="font-size: .85em"><?php echo esc_html_e('Page builder', 'xstore'); ?></div>
                <svg width="172" height="40" viewBox="0 0 172 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M69.7715 20.246L67.9814 24.5531C67.868 24.9432 67.6951 25.2813 67.4624 25.5664C67.11 25.9101 66.6865 26.082 66.1911 26.082C65.6956 26.082 65.2751 25.9101 64.9289 25.5664C64.6904 25.2813 64.5141 24.9432 64.4009 24.5531L61.0442 16.4718C60.9545 16.2095 60.8801 15.9183 60.8203 15.5979C60.8203 15.1148 60.9949 14.7026 61.3441 14.3619C61.6932 14.0211 62.1153 13.8508 62.6106 13.8508C63.1059 13.8508 63.5295 14.0196 63.8818 14.3574C64.1145 14.6486 64.2844 14.9893 64.3921 15.3796H64.4009L66.1911 19.5295L67.9814 15.3796H67.9904C67.9904 15.374 67.9932 15.365 67.9992 15.3533C68.047 14.9748 68.2171 14.6428 68.5095 14.3574C68.8556 14.0196 69.2762 13.8508 69.7715 13.8508C70.267 13.8508 70.6756 14.0108 70.9979 14.3312C71.3141 14.6516 71.4962 14.9923 71.5439 15.3533C71.55 15.365 71.553 15.374 71.553 15.3796H71.5618L73.3521 19.5295L75.1424 15.3796H75.1515C75.2588 14.9893 75.4317 14.6486 75.6706 14.3574C76.0168 14.0196 76.4373 13.8508 76.9326 13.8508C77.428 13.8508 77.8504 14.0211 78.1992 14.3619C78.5483 14.7026 78.7229 15.1148 78.7229 15.5979C78.6635 15.9183 78.5885 16.2095 78.4994 16.4718L75.1424 24.5531C75.0291 24.9432 74.8562 25.2813 74.6233 25.5664C74.2711 25.9101 73.8476 26.082 73.3521 26.082C72.8568 26.082 72.4362 25.9101 72.09 25.5664C71.8515 25.2813 71.6753 24.9432 71.5618 24.5531L69.7715 20.246Z" fill="#0772CE"></path>
                    <path d="M86.9078 22.2595C87.6325 22.2595 88.2521 21.9978 88.7667 21.4746C89.2809 20.9512 89.5381 20.321 89.5381 19.5838C89.5381 18.8466 89.2809 18.2163 88.7667 17.6929C88.2521 17.1699 87.6325 16.9084 86.9078 16.9084C86.1826 16.9084 85.5632 17.1699 85.0488 17.6929C84.5342 18.2163 84.277 18.8466 84.277 19.5838C84.277 20.321 84.5342 20.9512 85.0488 21.4746C85.5632 21.9978 86.1826 22.2595 86.9078 22.2595ZM80.7695 19.5838C80.7695 17.8595 81.3688 16.3881 82.5673 15.169C83.7658 13.9503 85.2125 13.3408 86.9078 13.3408C88.603 13.3408 90.0497 13.9503 91.2482 15.169C92.4463 16.3881 93.0456 17.8595 93.0456 19.5838C93.0456 21.3082 92.4463 22.7795 91.2482 23.9985C90.0497 25.2174 88.603 25.8267 86.9078 25.8267C85.9488 25.8267 85.0721 25.6337 84.277 25.2473V29.3944C84.277 29.8879 84.1062 30.3084 83.7641 30.6563C83.4222 31.0041 83.0084 31.178 82.5234 31.178C82.0381 31.178 81.6247 31.0041 81.2824 30.6563C80.9407 30.3084 80.7695 29.8879 80.7695 29.3944V19.5838Z" fill="#0772CE"></path>
                    <path d="M98.858 21.6733C99.3726 22.203 99.9922 22.4679 100.717 22.4679C101.442 22.4679 102.062 22.203 102.576 21.6733C103.091 21.143 103.348 20.5051 103.348 19.7579C103.348 19.0112 103.091 18.3733 102.576 17.8432C102.062 17.3133 101.442 17.0484 100.717 17.0484C99.9922 17.0484 99.3726 17.3133 98.858 17.8432C98.3436 18.3733 98.0866 19.0112 98.0866 19.7579C98.0866 20.5051 98.3436 21.143 98.858 21.6733ZM94.5791 9.03085C94.5791 8.53103 94.7499 8.10505 95.092 7.75271C95.4337 7.40057 95.8475 7.2243 96.3327 7.2243C96.818 7.2243 97.2314 7.40057 97.5735 7.75271C97.9154 8.10505 98.0866 8.53103 98.0866 9.03085V14.0224C98.8813 13.631 99.7583 13.4353 100.717 13.4353C102.412 13.4353 103.859 14.0525 105.057 15.2871C106.256 16.5217 106.855 18.012 106.855 19.7579C106.855 21.5043 106.256 22.9946 105.057 24.2292C103.859 25.4637 102.412 26.0808 100.717 26.0808C99.0217 26.0808 97.575 25.4637 96.3765 24.2292C95.1784 22.9946 94.5791 21.5043 94.5791 19.7579V9.03085Z" fill="#0772CE"></path>
                    <path d="M115.039 22.5873C115.764 22.5873 116.383 22.331 116.899 21.8185C117.413 21.306 117.671 20.6886 117.671 19.9662C117.671 19.2443 117.413 18.6269 116.899 18.1144C116.383 17.6017 115.764 17.3452 115.039 17.3452C114.314 17.3452 113.695 17.6017 113.181 18.1144C112.665 18.6269 112.409 19.2443 112.409 19.9662C112.409 20.6886 112.665 21.306 113.181 21.8185C113.695 22.331 114.314 22.5873 115.039 22.5873ZM117.994 25.3482C117.112 25.8374 116.127 26.082 115.039 26.082C113.344 26.082 111.897 25.4849 110.699 24.291C109.501 23.097 108.901 21.6555 108.901 19.9662C108.901 18.2774 109.486 16.8359 110.655 15.6419C111.824 14.4477 113.286 13.8508 115.039 13.8508C116.792 13.8508 118.254 14.4331 119.424 15.5979C120.592 16.763 121.177 18.2192 121.177 19.9662V24.3346C121.177 24.8181 121.005 25.2301 120.665 25.5708C120.323 25.9116 119.908 26.082 119.424 26.082C118.938 26.082 118.527 25.9101 118.187 25.5664C118.112 25.4968 118.047 25.4239 117.994 25.3482Z" fill="#0772CE"></path>
                    <path d="M126.804 19.1439L130.912 13.9593C131.26 13.6099 131.681 13.4353 132.176 13.4353C132.671 13.4353 133.092 13.6114 133.441 13.9637C133.791 14.3161 133.965 14.7421 133.965 15.2417C133.965 15.7419 133.793 16.166 133.447 16.5155L130.823 19.7579L133.447 22.992C133.793 23.3471 133.965 23.7744 133.965 24.2746C133.965 24.7742 133.791 25.2002 133.441 25.5527C133.092 25.9049 132.671 26.0808 132.176 26.0808C131.681 26.0808 131.26 25.9032 130.912 25.5479L128.595 22.6036L126.554 25.2049C126.483 25.3252 126.393 25.4396 126.286 25.5479C125.933 25.9032 125.511 26.0808 125.015 26.0808C124.518 26.0808 124.098 25.9049 123.748 25.5527C123.398 25.2002 123.225 24.7742 123.225 24.2746V9.03085C123.225 8.53103 123.398 8.10505 123.748 7.75271C124.098 7.40057 124.518 7.2243 125.015 7.2243C125.511 7.2243 125.931 7.40057 126.281 7.75271C126.63 8.10505 126.804 8.53103 126.804 9.03085V19.1439Z" fill="#0772CE"></path>
                    <path d="M140.195 21.7136C140.223 21.7486 140.257 21.7837 140.29 21.8185C140.806 22.331 141.425 22.5873 142.15 22.5873H144.78C145.266 22.5873 145.679 22.7577 146.021 23.0983C146.363 23.4391 146.535 23.8512 146.535 24.3346C146.535 24.8181 146.363 25.2301 146.021 25.5708C145.679 25.9116 145.266 26.082 144.78 26.082H142.15C140.455 26.082 139.008 25.4849 137.81 24.291C136.612 23.097 136.012 21.6555 136.012 19.9662C136.012 18.2774 136.612 16.8359 137.81 15.6419C139.008 14.4477 140.455 13.8508 142.15 13.8508C143.845 13.8508 145.292 14.4477 146.49 15.6419C147.688 16.8359 148.288 18.2774 148.288 19.9662C148.288 20.4497 148.116 20.8619 147.774 21.2024C147.432 21.5435 147.019 21.7136 146.535 21.7136H140.195ZM144.105 18.645C144.075 18.6103 144.619 18.2009 144.105 17.6884C143.591 17.1759 142.875 16.9194 142.15 16.9194C141.425 16.9194 140.806 17.1759 140.29 17.6884C139.776 18.2009 140.223 18.6103 140.195 18.645H144.105Z" fill="#0772CE"></path>
                    <path d="M151.668 15.1611C152.557 14.2875 153.892 13.8508 155.671 13.8508C157.148 13.8508 158.408 14.3604 159.453 15.3796C159.72 15.6477 159.95 15.9243 160.146 16.2095C160.425 16.5299 160.565 16.9086 160.565 17.3452C160.565 17.8288 160.391 18.2407 160.043 18.5815C159.697 18.9222 159.277 19.0927 158.785 19.0927C158.292 19.0927 157.875 18.9209 157.531 18.5772L156.935 17.8521C156.585 17.5142 156.163 17.3452 155.671 17.3452C155.18 17.3452 154.759 17.5159 154.413 17.8564C154.066 18.1972 153.892 18.6093 153.892 19.0927V24.3346C153.892 24.8181 153.718 25.2301 153.372 25.5708C153.025 25.9116 152.606 26.082 152.112 26.082C151.621 26.082 151.2 25.9116 150.854 25.5708C150.507 25.2301 150.333 24.8181 150.333 24.3346V19.0927C150.333 17.3452 150.78 16.0349 151.668 15.1611Z" fill="#0772CE"></path>
                    <path d="M171.817 15.1245C171.817 15.618 171.742 15.9895 171.593 16.2391L165.774 30.2862H165.765C165.688 30.417 165.593 30.5389 165.479 30.6518C165.128 31.0026 164.703 31.178 164.208 31.178C163.713 31.178 163.29 31.0041 162.941 30.6563C162.593 30.3084 162.417 29.8879 162.417 29.3944C162.417 29.0671 162.496 28.7701 162.651 28.5024H162.642L164.513 23.9183L161.299 16.0163C161.21 15.749 161.135 15.4516 161.075 15.1245C161.075 14.6312 161.249 14.2103 161.599 13.8624C161.948 13.5146 162.371 13.3408 162.866 13.3408C163.361 13.3408 163.784 13.5133 164.137 13.8581C164.369 14.1553 164.539 14.5032 164.647 14.9015H164.655L166.445 19.138L166.84 18.1925L168.236 14.9015H168.245C168.352 14.5032 168.526 14.1553 168.765 13.8581C169.111 13.5133 169.531 13.3408 170.027 13.3408C170.522 13.3408 170.944 13.5146 171.292 13.8624C171.642 14.2103 171.817 14.6312 171.817 15.1245Z" fill="#0772CE"></path>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M18.4243 0.0394287C25.2772 0.0394287 31.2499 3.78765 34.3839 9.33551C35.1425 9.20579 35.9225 9.13831 36.7182 9.13831C44.2959 9.13831 50.4383 15.2488 50.4383 22.7865C50.4383 30.2491 44.418 36.3129 36.9449 36.4333L36.7182 36.4349H35.6322V37.4019C35.6322 38.8149 34.4804 39.9609 33.0595 39.9609H17.6241C16.2034 39.9609 15.0516 38.8149 15.0516 37.4019L15.052 36.1263C6.55983 34.552 0.130859 27.1413 0.130859 18.2372C0.130859 8.18691 8.32133 0.0394287 18.4243 0.0394287ZM10.6696 10.523C10.4613 10.7301 10.3772 11.0284 10.4432 11.3103L10.4649 11.3867L13.6735 20.9738C13.797 21.3204 14.1312 21.5473 14.5 21.5351C14.8439 21.5293 15.1471 21.3179 15.2729 21.0047L15.297 20.9359L16.4501 17.1129C16.5645 16.737 16.8469 16.4374 17.212 16.2983L17.2976 16.2688L21.1382 15.1213C21.4907 15.0151 21.7339 14.6944 21.74 14.3278C21.7467 13.986 21.5458 13.6764 21.2359 13.54L21.1679 13.5134L11.537 10.3191C11.2325 10.2179 10.8965 10.2968 10.6696 10.523Z" fill="#0772CE"></path>
                </svg>
                <p><?php echo esc_html_e('Select this builder to create your site using WPBakery — a powerful drag & drop editor for WordPress.', 'xstore'); ?></p>
            </label>
        </div>
    </div>
	<div class="wizard-step-controllers">
        <a class="setup-button setup-button-arrow select-engine-btn" href="<?php echo ET_Setup_Wizard::get_controls_url('plugins&engine=elementor&version='.$_GET['version']); ?>"><?php esc_html_e('Continue', 'xstore'); ?>
            <svg class="arrow-icon" xmlns="http://www.w3.org/2000/svg" width="1.3em" height="1.3em" viewBox="0 0 32 32">
                <g fill="none" stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" stroke-miterlimit="10">
                    <circle class="arrow-icon--circle" cx="16" cy="16" r="15.12"></circle>
                    <path class="arrow-icon--arrow" d="M16.14 9.93L22.21 16l-6.07 6.07M8.23 16h13.98"></path>
                </g>
            </svg></a>
    </div>
</div>
