<?php
/*
Plugin Name: Classico Core
Plugin URI: http://8theme.com
Description: Classico Core Plugin for Classico theme
Version: 1.2.6
Author: 8theme
Text domain: classico-core
Author URI: http://themeforest.net/user/8theme
*/

if( !defined( 'WPINC' ) ) {
    die();
}

$theme = wp_get_theme(get_option('template'));

if ( $theme->get('Name') != 'Classico' || ( $theme->get('Name') != 'Classico' && get_option('template') != 'classico' ) ) {
    return false;
}

include 'inc/plugin-compatibilty.php';

if ( !classico_plugin_compatible() ) {
    return; 
}

/**
 * Load functions.
 * 
 * @since 1.0
 */
include 'inc/functions.php';

/**
 * Load shortcodes.
 * 
 * @since 1.0
 */
include 'inc/shortcodes.php';

/**
 * Load post-types.
 * 
 * @since 1.0
 */
include 'inc/post-type.php';

/**
 * Load taxonomies.
 * 
 * @since 1.0
 */
include 'inc/taxonomies.php';

/**
 * Load widgets.
 * 
 * @since 1.0
 */
include 'inc/widgets.php';

/**
 * Load importer.
 * 
 * @since 1.0
 */

if ( is_admin() ) { 
	include( 'inc/import.php');
}

add_action( 'after_setup_theme', 'classico_load_thirdparty', 999 );
if ( !function_exists('classico_load_thirdparty') ) {
	function classico_load_thirdparty() {
		if ( ! class_exists( 'TwitterOAuth' ) ) {
			include 'inc/twitteroauth/twitteroauth.php';
		}
		if ( ! class_exists('Woothemes_Testimonials') ) {
			include 'inc/testimonials/woothemes-testimonials.php';
		}
	}
}
?>