<?php  if ( ! defined('ABSPATH')) exit('No direct script access allowed');

// **********************************************************************// 
// ! Brands Filter Widget
// **********************************************************************// 
class Etheme_Brands_Widget extends WP_Widget {

    function __construct() {
        $widget_ops = array('classname' => 'etheme_widget_brands', 'description' => __( "Products Filter by brands", 'classico-core') );
        parent::__construct('etheme-brands', '8theme - '.__('Brands Filter', 'classico-core'), $widget_ops);
        $this->alt_option_name = 'etheme_widget_brans';
    }

    function widget($args, $instance) {
        global $wp_query;

        extract( $args );

        $title = $instance['title'];
        $dropdown = isset( $instance['dropdown'] ) ? $instance['dropdown'] : '';
        $hierarchy = isset( $instance['hierarchy'] ) ? $instance['hierarchy'] : '';
        $current_cat = false;
        $name = 'et_brand-' . rand( 100, 999 );

        if( ! $title == '' ) $title = $before_title . $title . $after_title;

        if ( is_tax( 'brand' ) ) {
            $current_cat   = $wp_query->queried_object;
            $cat_ancestors = get_ancestors( $current_cat->term_id, 'brand' );
        } elseif ( is_singular( 'product' ) ) {
            $product_category = wc_get_product_terms( $post->ID, 'brand', apply_filters( 'woocommerce_product_categories_widget_product_terms_args', array(
                'orderby' => 'parent',
            ) ) );
            if ( ! empty( $product_category ) ) {
                $current_cat   = end( $product_category );
                $cat_ancestors = get_ancestors( $current_cat->term_id, 'brand' );
            }
        }

        if ( $dropdown ) {
            $class = 'et_brand-dropdown';
            $option_none = esc_html__( 'Select a brand', 'classico-core' );
        } else {
            $class = 'et_brand-list';
            $option_none = false;
        }

        $args = array(
            'taxonomy' => 'brand',
            'depth' => 5,
            'name' => 'brand',
            'id' => $name,
            'class' => $class,
            'hide_empty'=> false,
            'orderby'=> 'name',
            'hierarchical' => $hierarchy,
            'show_option_none' => $option_none,
            'value_field' => 'slug',
            'selected' => $current_cat ? $current_cat->slug : '',
            'echo' => false
        );

        $out = wp_dropdown_categories( $args );

        if ( ! $dropdown ) {
            $out = str_replace( 'select', 'ul', $out );
            $out = str_replace( 'option', 'li', $out );
            $out = str_replace( '&nbsp;', '', $out );
            $out = str_replace( 'value', 'data-value', $out );
            wc_enqueue_js( 
                "
                    jQuery( '.etheme_widget_brands ul li' ).on( 'click', function() {
                        if ( jQuery(this).data('value') != '' ) {
                            var this_page = '';
                            var home_url  = '" . esc_js( home_url( '/' ) ) . "';
                            if ( home_url.indexOf( '?' ) > 0 ) {
                                this_page = home_url + '&brand=' + jQuery(this).data('value');
                            } else {
                                this_page = home_url + '?brand=' + jQuery(this).data('value');
                            }
                            location.href = this_page;
                        }
                    });
                    jQuery( '.etheme_widget_brands ul li' ).each(function( index ) {
                       $(this).attr( 'title', '" . esc_html__( 'View all products from ', 'classico-core' ) . "' + $(this).data( 'value' ) );
                    });
                "
            );
        } else {
            wc_enqueue_js( 
                "
                    jQuery( '.etheme_widget_brands select' ).change( function() {
                        if ( jQuery(this).val() != '' ) {
                            if ( jQuery(this).val() == -1 ) {
                                var shop_url  = '" . esc_js( get_permalink( wc_get_page_id( 'shop' ) ) ) . "';
                                location.href = shop_url;
                                return;
                            }
                            var this_page = '';
                            var home_url  = '" . esc_js( home_url( '/' ) ) . "';
                            if ( home_url.indexOf( '?' ) > 0 ) {
                                this_page = home_url + '&brand=' + jQuery(this).val();
                            } else {
                                this_page = home_url + '?brand=' + jQuery(this).val();
                            }
                            location.href = this_page;
                        }
                    });
                "
            );
        }

        echo $before_widget . $title . $out . $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = $new_instance['title'];
        $instance['dropdown'] = $new_instance['dropdown'];
        $instance['hierarchy'] = $new_instance['hierarchy'];
        return $instance;
    }

    function form( $instance ) {
        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $dropdown = isset( $instance['dropdown'] ) ? $instance['dropdown'] : '';
        $hierarchy = isset( $instance['hierarchy'] ) ? $instance['hierarchy'] : '';

        etheme_widget_input_text( esc_html__( 'Title', 'classico-core' ), $this->get_field_id( 'title' ), $this->get_field_name( 'title' ), $title);;
        etheme_widget_input_checkbox( esc_html__( 'Show as dropdown', 'classico-core' ), $this->get_field_id( 'dropdown' ), $this->get_field_name( 'dropdown' ), checked( $dropdown, true, false ), 1 );
        etheme_widget_input_checkbox( esc_html__( 'Show hierarchy', 'classico-core' ), $this->get_field_id( 'hierarchy' ), $this->get_field_name( 'hierarchy' ), checked( $hierarchy, true, false ), 1 );
    }
}