<?php 

	add_action( 'init', 'et_create_brand_taxonomies', 0 );
	if(!function_exists('et_create_brand_taxonomies')) {
		function et_create_brand_taxonomies() {
			$labels = array(
				'name'              => _x( 'Brands', '', 'classico-core' ),
				'singular_name'     => _x( 'Brand', '', 'classico-core' ),
				'search_items'      => __( 'Search Brands', 'classico-core' ),
				'all_items'         => __( 'All Brands', 'classico-core' ),
				'parent_item'       => __( 'Parent Brand', 'classico-core' ),
				'parent_item_colon' => __( 'Parent Brand:', 'classico-core' ),
				'edit_item'         => __( 'Edit Brand', 'classico-core' ),
				'update_item'       => __( 'Update Brand', 'classico-core' ),
				'add_new_item'      => __( 'Add New Brand', 'classico-core' ),
				'new_item_name'     => __( 'New Brand Name', 'classico-core' ),
				'menu_name'         => __( 'Brands', 'classico-core' ),
			);

			$args = array(
				'hierarchical'      => true,
				'labels'            => $labels,
				'show_ui'           => true,
				'show_admin_column' => true,
				'query_var'         => true,
	            'capabilities'			=> array(
	            	'manage_terms' 		=> 'manage_product_terms',
					'edit_terms' 		=> 'edit_product_terms',
					'delete_terms' 		=> 'delete_product_terms',
					'assign_terms' 		=> 'assign_product_terms',
	            ),
				'rewrite'           => array( 'slug' => 'brand' ),
			);

			register_taxonomy( 'brand', array( 'product' ), $args );
		}
	}

?>