<?php  defined('ABSPATH') || exit('No direct script access allowed');


// **********************************************************************// 
// ! Register New Element: Testimonials Widget
// **********************************************************************//
if(!function_exists('et_register_vc_testimonials')) {
	function et_register_vc_testimonials() {
		if(!function_exists('vc_map')) return;
	    $testimonials_params = array(
	      'name' => 'Testimonials widget',
	      'base' => 'testimonials',
	      'icon' => 'icon-wpb-etheme',
	      'category' => 'Eight Theme',
	      'params' => array(
	        array(
	          "type" => "textfield",
	          "heading" => __("Limit", 'classico-core'),
	          "param_name" => "limit",
	          "description" => __('How many testimonials to show? Enter number.', 'classico-core')
	        ),
	        array(
	          "type" => "dropdown",
	          "heading" => __("Display type", "classico-core"),
	          "param_name" => "type",
	          "value" => array( 
	              "", 
	              __("Slider", 'classico-core') => 'slider',
	              __("Grid", 'classico-core') => 'grid'
	            )
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Interval", 'classico-core'),
	          "param_name" => "interval",
	          "description" => __('Interval between slides. In milliseconds. Default: 10000', 'classico-core'),
	          "dependency" => Array('element' => "type", 'value' => array('slider'))
	        ),
	        array(
	          "type" => "dropdown",
	          "heading" => __("Show Control Navigation", "classico-core"),
	          "param_name" => "navigation",
	          "dependency" => Array('element' => "type", 'value' => array('slider')),
	          "value" => array( 
	              "", 
	              __("Hide", 'classico-core') => false,
	              __("Show", 'classico-core') => true
	            )
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Category", 'classico-core'),
	          "param_name" => "category",
	          "description" => __('Display testimonials from category.', 'classico-core')
	        ),
	      )
	
	    );  
	
	    vc_map($testimonials_params);
	}
}