<?php 
	if ( !function_exists('etheme_featured_post_shortcode') ) {
		function etheme_featured_post_shortcode($atts) {
		    $a = shortcode_atts(array(
		        'title' => '',
		        'id' => '',
		        'class' => '',
		        'more_posts' => 1
		    ),$atts);
		    $limit = 1;
		    $width = 300;
		    $height = 300;
		    $lightbox = etheme_get_option('blog_lightbox');
		    $blog_slider = etheme_get_option('blog_slider');
		    $posts_url = get_permalink(get_option('page_for_posts'));
		    $args = array(
		        'p'                     => $a['id'],
		        'post_type'             => 'post',
		        'ignore_sticky_posts'   => 1,
		        'no_found_rows'         => 1,
		        'posts_per_page'        => $limit
		    );

		    $the_query = new WP_Query( $args ); 
		    ob_start();
		    ?>

		    <?php if ( $the_query->have_posts() ) : ?>

		        <?php while ( $the_query->have_posts() ) : $the_query->the_post();  $postId = get_the_ID(); ?>

		            <div class="featured-posts <?php echo $a['class']; ?>">
		                <?php if ($a['title'] != ''): ?>
		                    <h3 class="title a-left"><span><?php echo $a['title']; ?></span></h3>
		                    <?php if ($a['more_posts']): ?>
		                            <?php echo '<a href="'.$posts_url.'" class="show-all-posts hidden-tablet hidden-phone">'.__('View more posts', 'classico-core').'</a>'; ?>
		                    <?php endif ?>
		                <?php endif ?>
		                <div class="featured-post row">
		                    <div class="col-md-6">
		                        <?php 
		                            $width = etheme_get_option('blog_page_image_width');
		                            $height = etheme_get_option('blog_page_image_height');
		                            $crop = etheme_get_option('blog_page_image_cropping');
		                        ?>

		                        <?php $images = etheme_get_images($width,$height,$crop); ?>

		                        <?php if ( is_array($images) && count($images)>0 && has_post_thumbnail()): ?>
		                            <div class="post-images nav-type-small<?php if (count($images)>1): ?> images-slider<?php endif; ?>">
		                                <ul class="slides">
		                                     <li><a href="<?php the_permalink(); ?>"><img src="<?php echo $images[0]; ?>"></a></li>
		                                </ul>
		                                <div class="blog-mask">
		                                    <div class="mask-content">
		                                        <?php if($lightbox): ?><a href="<?php echo etheme_get_image(get_post_thumbnail_id($postId)); ?>" rel="lightbox"><i class="fa fa-resize-full"></i></a><?php endif; ?>
		                                        <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i></a>
		                                    </div>
		                                </div>
		                            </div>
		                        <?php endif ?>
		                    </div>
		                    <div class="col-md-6">
		                        <h4 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
		                        <div class="post-info">
		                            <span class="posted-on">
		                                <?php _e('Posted on', 'classico-core') ?>
		                                <?php the_time(get_option('date_format')); ?> 
		                                <?php _e('at', 'classico-core') ?> 
		                                <?php the_time(get_option('time_format')); ?>
		                            </span> 
		                            <span class="posted-by"> <?php _e('by', 'classico-core');?> <?php the_author_posts_link(); ?></span>
		                        </div>
		                        <div class="post-description">
		                            <?php the_excerpt(); ?>
		                            <a href="<?php the_permalink(); ?>" class="button read-more"><?php _e('Read More', 'classico-core') ?></a>
		                        </div>
		                    </div>
		                </div>
		            </div>

		        <?php endwhile; ?>

		        <?php wp_reset_postdata(); ?>

		    <?php else:  ?>

		        <p><?php _e( 'Sorry, no posts matched your criteria.', 'classico-core' ); ?></p>

		    <?php endif; ?>

		    <?php
		    $output = ob_get_contents();
		    ob_end_clean();

		    return $output;

		}
	}
?>