<?php 
	if ( !function_exists('etheme_share_shortcode') ) {
		function etheme_share_shortcode($atts, $content = null) {
			extract(shortcode_atts(array(
				'title'  => '',
				'text' => '',
				'tooltip' => 1,
		        'twitter' => 1,
		        'facebook' => 1,
		        'pinterest' => 1,
		        'mail' => 1,
				'class' => ''
			), $atts));
			global $post;
			if(!isset($post->ID)) return;
		    $html = '';
			$permalink = get_permalink($post->ID);
			$tooltip_class = '';
			if($tooltip) {
				$tooltip_class = 'title-toolip';
			}
			$image =  etheme_get_image( get_post_thumbnail_id($post->ID), 150,150,false);
			$post_title = rawurlencode(get_the_title($post->ID)); 
			if($title) $html .= '<span class="share-title">'.$title.'</span>';
		    $html .= '
		        <ul class="menu-social-icons '.$class.'">
		    ';
		    if($twitter == 1) {
		        $html .= '
		                <li>
		                    <a href="https://twitter.com/share?url='.$permalink.'&text='.$post_title.'" class="'.$tooltip_class.'" title="'.__('Twitter', 'classico-core').'" target="_blank">
		                        <i class="ico-twitter"></i>
		                        <svg width="38" height="38" xmlns="http://www.w3.org/2000/svg" class="circle">
		                                <circle cx="19" cy="19" r="18" fill="rgba(255,255,255,0)" stroke="#000000"></circle>
		                        </svg>
		                    </a>
		                </li>
		        ';
		    }
		    if($facebook == 1) {
		        $html .= '
		                <li>
		                    <a href="http://www.facebook.com/sharer.php?u='.$permalink.'&amp;images='.$image.'" class="'.$tooltip_class.'" title="'.__('Facebook', 'classico-core').'" target="_blank">
		                        <i class="ico-facebook"></i>
		                        <svg width="38" height="38" xmlns="http://www.w3.org/2000/svg" class="circle">
		                                <circle cx="19" cy="19" r="18" fill="rgba(255,255,255,0)" stroke="#000000"></circle>
		                        </svg>
		                    </a>
		                </li>
		        ';
		    }

		    if($pinterest == 1) {
		        $html .= '
		                <li>
		                    <a href="http://pinterest.com/pin/create/button/?url='.$permalink.'&amp;media='.$image.'&amp;description='.$post_title.'" class="'.$tooltip_class.'" title="'.__('Pinterest', 'classico-core').'" target="_blank">
		                        <i class="ico-pinterest"></i>
		                        <svg width="38" height="38" xmlns="http://www.w3.org/2000/svg" class="circle">
		                                <circle cx="19" cy="19" r="18" fill="rgba(255,255,255,0)" stroke="#000000"></circle>
		                        </svg>
		                    </a>
		                </li>
		        ';
		    }

		    if($mail == 1) {
		        $mailto = etheme_get_option('contacts_email') ? etheme_get_option('contacts_email') : 'enteryour@addresshere.com';
		        $html .= '
		                <li>
		                    <a href="mailto:'.$mailto.'?subject='.$post_title.'&amp;body=Check%20this%20out:%20'.$permalink.'" class="'.$tooltip_class.'" title="'.__('Mail to friend', 'classico-core').'" target="_blank">
		                        <i class="ico-envelope"></i>
		                        <svg width="38" height="38" xmlns="http://www.w3.org/2000/svg" class="circle">
		                                <circle cx="19" cy="19" r="18" fill="rgba(255,255,255,0)" stroke="#000000"></circle>
		                        </svg>
		                    </a>
		                </li>
		        ';
		    }
		    
		    $html .= '
		        </ul>
		    ';
			return $html;
		}
	}

?>