<?php  defined('ABSPATH') || exit('No direct script access allowed');

// **********************************************************************// 
// ! products
// **********************************************************************// 

if ( !function_exists('etheme_products_shortcode') ) {
function etheme_products_shortcode($atts, $content) {
    if ( ! etheme_required_plugin( 'WooCommerce' ) ) return false;

      global $wpdb, $woocommerce_loop;

      $from_first = '';
      
      extract(shortcode_atts(array( 
          'ids' => '',
          'skus' => '',
          'columns' => 4,
          'shop_link' => 1,
          'limit' => 20,
          'categories' => '',
          'block_id' => false,
          'hover' => '',
          'type' => 'slider',
          'style' => 'default',
          'from_first' => '',
          'products' => '', //featured new sale bestsellings recently_viewed
          'title' => '',
          'desktop' => 4,
          'notebook' => 4,
          'tablet' => 3,
          'phones' => 1,
          'orderby' => '',
          'order' => 'ASC',
      ), $atts)); 

      $args = array(
          'post_type'             => 'product',
          'ignore_sticky_posts'   => 1,
          'no_found_rows'         => 1,
          'posts_per_page'        => $limit,
          'orderby'               => $orderby,
          'order'                 => $order,
      );

      $woocommerce_loop['hover'] = $hover;

      $args['tax_query'][] = array(
          'taxonomy' => 'product_visibility',
          'field'    => 'name',
          'terms'    => 'hidden',
          'operator' => 'NOT IN',
      );

      if ( $products == 'featured' ) {
        $args['tax_query'][] = array(
            'taxonomy' => 'product_visibility',
            'field'    => 'name',
            'terms'    => 'featured',
            'operator' => 'IN',
        );
      }

      if ($products == 'new') {
          $args['meta_query'][] = array(
              'key'       => ET_PREFIX . 'product_new',
              'value'     => 'on',
              'compare'   => '='
          );
      }

    if ($products == 'sale') {
        $product_ids_on_sale = wc_get_product_ids_on_sale ();
        $args['post__in'] = array_merge( array( 0 ), $product_ids_on_sale );
    }

      if ($products == 'bestsellings') {
          $args['meta_key'] = 'total_sales';
          $args['orderby'] = 'meta_value_num';
      }

      if ($products == 'recently_viewed') {
          $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', $_COOKIE['woocommerce_recently_viewed'] ) : array();
          $viewed_products = array_filter( array_map( 'absint', $viewed_products ) );

          if ( empty( $viewed_products ) )
            return;
          $args['post__in'] = $viewed_products;
          $args['orderby'] = 'rand';
      }


      if($skus != ''){
          $skus = explode(',', $atts['skus']);
          $skus = array_map('trim', $skus);
          $args['meta_query'][] = array(
              'key'       => '_sku',
              'value'     => $skus,
              'compare'   => 'IN'
          );
      }

      if($ids != ''){
          $ids = explode(',', $atts['ids']);
          $ids = array_map('trim', $ids);
          $args['post__in'] = $ids;
      }

      // Narrow by categories
      if ( $categories != '' ) {
        $categories = explode(",", $categories);
        $gc = array();
        foreach ( $categories as $grid_cat ) {
            array_push($gc, $grid_cat);
        }
        $gc = implode(",", $gc);
        ////http://snipplr.com/view/17434/wordpress-get-category-slug/
        //$args['category_name'] = $gc;
        $pt = array('product');


        $taxonomies = get_taxonomies('', 'object');
        $args['tax_query'] = array('relation' => 'OR');
        foreach ( $taxonomies as $t ) {
            if ( in_array($t->object_type[0], $pt) ) {
                $args['tax_query'][] = array(
                    'taxonomy' => $t->name,//$t->name,//'portfolio_category',
                    'terms' => $categories,
                    'field' => 'id',
                );
            }
        }
      }

      $customItems = array(
          'desktop' => $desktop,
          'notebook' => $notebook,
          'tablet' => $tablet,
          'phones' => $phones
      );
        
      if ($type == 'slider') {
      	$slider_args = array(
      		'title' => $title,
      		'shop_link' => $shop_link,
      		'slider_type' => false,
      		'items' => $customItems,
      		'style' => $style,
      	);
          ob_start();
          etheme_create_slider($args, $slider_args);
          $output = ob_get_contents();
          ob_end_clean();
      } elseif($type == 'full-width') {
      	$slider_args = array(
      		'title' => $title,
      		'shop_link' => $shop_link,
      		'slider_type' => 'swiper',
          'customItems' => $customItems,
          'from_first' => $from_first,
      		'style' => $style,
      		'block_id' => $block_id
      	);
          ob_start();
          etheme_create_slider($args, $slider_args);
          $output = ob_get_contents();
          ob_end_clean();
      } else {
          $woocommerce_loop['view_mode'] = $type;
          $output = etheme_products($args, $title, $columns);
      }
      
      return $output;
  }
}

// **********************************************************************// 
// ! Register New Element: products
// **********************************************************************//
add_action( 'init', 'et_register_vc_products');
if(!function_exists('et_register_vc_products')) {
	function et_register_vc_products() {
		if(!function_exists('vc_map')) return;

      $order_by_values = array(
        '',
        __( 'Date', 'classico-core' ) => 'date',
        __( 'ID', 'classico-core' ) => 'ID',
        __( 'Author', 'classico-core' ) => 'author',
        __( 'Title', 'classico-core' ) => 'title',
        __( 'Modified', 'classico-core' ) => 'modified',
        __( 'Random', 'classico-core' ) => 'rand',
        __( 'Comment count', 'classico-core' ) => 'comment_count',
        __( 'Menu order', 'classico-core' ) => 'menu_order',
      );

      $order_way_values = array(
        '',
        __( 'Descending', 'classico-core' ) => 'DESC',
        __( 'Ascending', 'classico-core' ) => 'ASC',
      );

      $static_blocks = array('--choose--' => '');
      
      foreach(et_get_static_blocks() as $value) {
        $static_blocks[$value['label']] = $value['value'];
      }
	    $params = array(
	      'name' => '[8THEME] Products',
	      'base' => 'etheme_products',
	      'icon' => 'icon-wpb-etheme',
	      'category' => 'Eight Theme',
	      'params' => array(
	        array(
	          "type" => "textfield",
	          "heading" => __("Title", 'classico-core'),
	          "param_name" => "title"
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("IDs", 'classico-core'),
	          "param_name" => "ids"
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("SKUs", 'classico-core'),
	          "param_name" => "skus"
	        ),
	        array(
	          "type" => "dropdown",
	          "heading" => __("Display Type", 'classico-core'),
	          "param_name" => "type",
	          "value" => array( 
                __("Slider", 'classico-core') => 'slider',
                __("Slider full width (LOOK BOOK)", 'classico-core') => 'full-width', 
                __("Grid", 'classico-core') => 'grid', 
                __("List", 'classico-core') => 'list'
              )
	        ),

          array(
            "type" => "dropdown",
            "heading" => __("Start from first slide", 'classico-core'),
            "param_name" => "from_first",
            "dependency" => Array('element' => "type", 'value' => array('full-width')),
            "value" => array( 
                '' => '',
                __("Yes", 'classico-core') => 'yes', 
                __("No", 'classico-core') => 'no'
              )
          ),
          array(
            "type" => "dropdown",
            "dependency" => Array('element' => "type", 'value' => array('full-width')),
            "heading" => __("Static block for the first slide of the LOOK BOOK", 'classico-core'),
            "param_name" => "block_id",
            "value" => $static_blocks
          ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Columns", 'classico-core'),
	          "param_name" => "columns",
	          "dependency" => Array('element' => "type", 'value' => array('grid'))
	        ),
            array(
              "type" => "dropdown",
              "heading" => __("Product view", 'classico-core'),
              "param_name" => "style",
              "dependency" => Array('element' => "type", 'value' => array('slider')),
              "value" => array( __("Default", 'classico-core') => 'default', __("Advanced", 'classico-core') => 'advanced')
            ),
            array(
              "type" => "dropdown",
              "heading" => __("Product hover", 'classico-core'),
              "param_name" => "hover",
              "value" => array( 
                    __("Default", 'classico-core') => '', 
                    __("Disable", 'classico-core') => 'disable', 
                    __("Swap", 'classico-core') => 'swap', 
                    __("Default light", 'classico-core') => 'default-light', 
                    __("Default dark", 'classico-core') => 'default-dark', 
                    __("Images Slider", 'classico-core') => 'slider', 
                    __("Mask", 'classico-core') => 'mask',
                    __('Quick view on img click', 'classico-core') => 'quick-view'
                )
            ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Number of items on desktop", 'classico-core'),
	          "param_name" => "desktop",
	          "dependency" => Array('element' => "type", 'value' => array('slider'))
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Number of items on notebook", 'classico-core'),
	          "param_name" => "notebook",
	          "dependency" => Array('element' => "type", 'value' => array('slider'))
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Number of items on tablet", 'classico-core'),
	          "param_name" => "tablet",
	          "dependency" => Array('element' => "type", 'value' => array('slider'))
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Number of items on phones", 'classico-core'),
	          "param_name" => "phones",
	          "dependency" => Array('element' => "type", 'value' => array('slider'))
	        ),
	        array(
	          "type" => "dropdown",
	          "heading" => __("Products type", 'classico-core'),
	          "param_name" => "products",
	          "value" => array( __("All", 'classico-core') => '', __("Featured", 'classico-core') => 'featured', __("New", 'classico-core') => 'new', __("Sale", 'classico-core') => 'sale', __("Recently viewed", 'classico-core') => 'recently_viewed', __("Bestsellings", 'classico-core') => 'bestsellings')
	        ),
          array(
            'type' => 'dropdown',
            'heading' => __( 'Order by', 'classico-core' ),
            'param_name' => 'orderby',
            'value' => $order_by_values,
            'description' => sprintf( __( 'Select how to sort retrieved products. More at %s.', 'classico-core' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' )
          ),
          array(
            'type' => 'dropdown',
            'heading' => __( 'Order way', 'classico-core' ),
            'param_name' => 'order',
            'value' => $order_way_values,
            'description' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'classico-core' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' )
          ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Limit", 'classico-core'),
	          "param_name" => "limit"
	        ),
	        array(
	          "type" => "textfield",
	          "heading" => __("Categories IDs", 'classico-core'),
	          "param_name" => "categories"
	        )
	      )
	
	    );  
	
	    vc_map($params);
	}
}
