<?php  defined('ABSPATH') || exit('No direct script access allowed');

// **********************************************************************// 
// ! contact_form
// **********************************************************************// 

if ( !function_exists('etheme_contact_form_shortcode') ) {
function etheme_contact_form_shortcode($atts, $content) {
    $output = '';

    extract(shortcode_atts(array(
    	'design' => '1',
      'class'  => '',
    ), $atts));

      ob_start();
      ?>
        <div id="contactsMsgs"></div>
        <form action="<?php the_permalink(); ?>" method="get" id="contact-form" class="contact-form <?php echo $class; ?> design-<?php echo $design; ?>">
            
            <div class="form-group">
              <p class="form-name">
                <label for="name" class="control-label"><?php esc_html_e('Name and Surname', 'classico-core') ?> <span class="required">*</span></label>
                <input type="text" name="contact-name" class="required-field form-control" id="contact-name">
              </p>
            </div>

              <div class="form-group">
                  <p class="form-name">
                    <label for="contact-email" class="control-label"><?php esc_html_e('Email', 'classico-core') ?> <span class="required">*</span></label>
                    <input type="text" name="contact-email" class="required-field form-control" id="contact-email">
                  </p>
              </div>
              
              <div class="form-group">
                <p class="form-name">
                  <label for="contact-website" class="control-label"><?php esc_html_e('Website', 'classico-core') ?></label>
                  <input type="text" name="contact-website" class="form-control" id="contact-website">
                </p>
              </div>

              <div class="form-group">
                <p class="form-textarea">
                  <label for="contact_msg" class="control-label"><?php esc_html_e('Message', 'classico-core'); ?> <span class="required">*</span></label>
                  <textarea name="contact-msg" id="contact-msg" class="required-field form-control" cols="30" rows="7"></textarea>
                </p>
              </div>

              <?php if ( $content ): ?>
                <div class="privacy-policy">
                  <?php echo do_shortcode( $content ); ?>
                </div>
              <?php endif ?>
              
              <div class="captcha-block">
                <?php echo et_display_captcha(); ?>
              </div>
              
              <div class="form-group">
                <p class="pull-right">
                  <input type="hidden" name="contact-submit" id="contact-submit" value="true" >
                  <span class="spinner"><?php esc_html_e('Sending...', 'classico-core') ?></span>
                  <button class="btn btn-black big" id="submit" type="submit"><?php esc_html_e('Send message', 'classico-core') ?></button>
                </p>
              </div>
            
              <div class="clearfix"></div>
          </form>
      <?php
      $output = ob_get_contents();
      ob_end_clean();
      
      return $output;
  }
}

// **********************************************************************// 
// ! Register New Element: contact_form
// **********************************************************************//
if(!function_exists('et_register_vc_contact_form')) {
	function et_register_vc_contact_form() {
		if(!function_exists('vc_map')) return;
	    $params = array(
	      'name' => '[8THEME] Contact Form',
	      'base' => 'et_contact_form',
	      'icon' => 'icon-wpb-etheme',
	      'category' => 'Eight Theme',
	      'params' => array(
	        array(
	          "type" => "textfield",
	          "heading" => esc_html__("Extra Class", 'classico-core'),
	          "param_name" => "class",
	          "description" => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'classico-core')
	        ),
          array(
            "type" => "textarea_html",
            "heading" => esc_html__("Privacy Policy", 'classico-core'),
            "param_name" => "content",
            "value" => 'Your personal data will be used to support your experience throughout this website, purposes described in our <a href="#">privacy policy</a>.',
            "description" => esc_html__('Change your Privacy Policy .', 'classico-core')
          )
	      )
	
	    );  
	
	    vc_map($params);
	}
}
