<?php 

	if ( !classico_theme_old() ) {

		function classico_load_shortcodes() {
			$load_shortcodes = array(
				'banner',
				'brands',
				'title',
				'divider',
				'categories',
				'posts-carousel',
				'posts-grid',
				'images-carousel',
				'icon-box',
				'tabs',
				'tab',
				'contact_form',
				'products',
				'row',
				'team-member',
				'testimonials',
				'twitter',
				'follow',

				'quick_view',
				'button',
				'alert',
				'counter',
				'callto',
				'dropcap',
				'blockquote',
				'checklist',
				'toggle_block',
				'toggle',
				'countdown',
				'qrcode',
				'project_links',
				'tooltip',
				'share',
				'googlechart',
				'googlefont',
				'single_post',
				'block',

				'vc_global',
				'portfolio',
			);

			foreach ($load_shortcodes as $key ) {
				et_load_shortcode($key);
			}
		}

		$shortcodes_init = array(
			'classico_load_shortcodes',
			'et_register_vc_banner',
			'et_register_vc_brands',
			'et_register_vc_scslug',
			'et_register_vc_contact_form',
			'et_register_vc_divider',
			'et_register_vc_follow',
			'et_register_vc_images_carousel',
			'et_register_vc_carousel',
			'et_register_vc_posts_grid',
			'et_register_vc_products',
			'et_register_vc_row',
			'et_register_vc_team_member',
			'et_register_vc_testimonials',
			'et_register_vc_title',
			'et_register_vc_twitter',
			'et_register_vc_icon_box',
			'et_register_vc_vc_tabs',
		);

		foreach ($shortcodes_init as $key) {
			add_action( 'init', $key );
		}

	}

	add_action( 'init', 'classico_shortcodes_init' );

	if ( !function_exists('classico_shortcodes_init') ) {
		function classico_shortcodes_init() {
			$shortcodes = array(
				'banner' => 'etheme_banner_shortcode',
				'brands' => 'et_brands',
				'etheme_categories' => 'etheme_categories_shortcode',
				'et_contact_form' => 'etheme_contact_form_shortcode',
				'hr' => 'etheme_divider_shortcode',
				'divider' => 'etheme_divider_shortcode',
				'follow' => 'et_follow_shortcode',
				'icon_box' => 'etheme_icon_box_shortcode',
				'etheme_products' => 'etheme_products_shortcode',
				'team_member' => 'etheme_team_member_shortcode',
				'title' => 'etheme_title_shortcode',
				'twitter' => 'etheme_twitter_shortcode',

				'quick_view' => 'etheme_quick_view_shortcodes',
				'button' => 'etheme_btn_shortcode',
				'alert' => 'etheme_alert_shortcode',
				'counter' => 'etheme_counter_shortcode',
				'callto' => 'etheme_callto_shortcode',
				'dropcap' => 'etheme_dropcap_shortcode',
				'blockquote' => 'etheme_blockquote_shortcode',
				'checklist' => 'etheme_checklist_shortcode',
				'toggle_block' => 'etheme_toggle_block_shortcode',
				'toggle' => 'etheme_toggle_shortcode',
				'tabs' => 'etheme_tabs_shortcode',
				'tab' => 'etheme_tab_shortcode',
				'countdown' => 'etheme_countdown_shortcode',
				'qrcode' => 'etheme_qrcode_shortcode',
				'project_links' => 'etheme_project_links',
				'tooltip' => 'etheme_tooltip_shortcode',
				'share' => 'etheme_share_shortcode',
				'googlechart' => 'etheme_googlechart_shortcode',
				'googlefont' => 'etheme_googlefont_shortcode',
				'single_post' => 'etheme_featured_post_shortcode',
				'block' => 'etheme_block_shortcode',

				'portfolio' => 'et_portfolio_shortcode',
				'portfolio_grid' => 'et_portfolio_grid_shortcode',
			);

			foreach ($shortcodes as $key => $value) {
				add_shortcode($key, $value);
			}
		}
	}


?>