<?php 

	/*
	* Load Shortcode file
	* ******************************************************************* */

	if(!function_exists('et_load_shortcode')) {
		function et_load_shortcode($name) {
			require_once('shortcodes/'.$name.'.php');
		}
	}

	// VC helpers icons
	
	if(!function_exists('et_get_icons')) {

	    function et_get_icons() {
	        $iconsArray = array("adjust","anchor","archive","arrows","arrows-h","arrows-v","asterisk","ban","bar-chart-o","barcode","bars","beer","bell","bell-o","bolt","book","bookmark","bookmark-o","briefcase","bug","building-o","bullhorn","bullseye","calendar","calendar-o","camera","camera-retro","caret-square-o-down","caret-square-o-left","caret-square-o-right","caret-square-o-up","certificate","check","check-circle","check-circle-o","check-square","check-square-o","circle","circle-o","clock-o","cloud","cloud-download","cloud-upload","code","code-fork","coffee","cog","cogs","comment","comment-o","comments","comments-o","compass","credit-card","crop","crosshairs","cutlery","dashboard","desktop","dot-circle-o","download","edit","ellipsis-h","ellipsis-v","envelope","envelope-o","eraser","exchange","exclamation","exclamation-circle","exclamation-triangle","external-link","external-link-square","eye","eye-slash","female","fighter-jet","film","filter","fire","fire-extinguisher","flag","flag-checkered","flag-o","flash","flask","folder","folder-o","folder-open","folder-open-o","frown-o","gamepad","gavel","gear","gears","gift","glass","globe","group","hdd-o","headphones","heart","heart-o","home","inbox","info","info-circle","key","keyboard-o","laptop","leaf","legal","lemon-o","level-down","level-up","lightbulb-o","location-arrow","lock","magic","magnet","mail-forward","mail-reply","mail-reply-all","male","map-marker","meh-o","microphone","microphone-slash","minus","minus-circle","minus-square","minus-square-o","mobile","mobile-phone","money","moon-o","music","pencil","pencil-square","pencil-square-o","phone","phone-square","picture-o","plane","plus","plus-circle","plus-square","plus-square-o","power-off","print","puzzle-piece","qrcode","question","question-circle","quote-left","quote-right","random","refresh","reply","reply-all","retweet","road","rocket","rss","rss-square","search","search-minus","search-plus","share","share-square","share-square-o","shield","shopping-cart","sign-in","sign-out","signal","sitemap","smile-o","sort","sort-alpha-asc","sort-alpha-desc","sort-amount-asc","sort-amount-desc","sort-asc","sort-desc","sort-down","sort-numeric-asc","sort-numeric-desc","sort-up","spinner","square","square-o","star","star-half","star-half-empty","star-half-full","star-half-o","star-o","subscript","suitcase","sun-o","superscript","tablet","tachometer","tag","tags","tasks","terminal","thumb-tack","thumbs-down","thumbs-o-down","thumbs-o-up","thumbs-up","ticket","times","times-circle","times-circle-o","tint","toggle-down","toggle-left","toggle-right","toggle-up","trash-o","trophy","truck","umbrella","unlock","unlock-alt","unsorted","upload","user","users","video-camera","volume-down","volume-off","volume-up","warning","wheelchair","wrench", "check-square","check-square-o","circle","circle-o","dot-circle-o","minus-square","minus-square-o","plus-square","plus-square-o","square","square-o","bitcoin","btc","cny","dollar","eur","euro","gbp","inr","jpy","krw","money","rmb","rouble","rub","ruble","rupee","try","turkish-lira","usd","won","yen","align-center","align-justify","align-left","align-right","bold","chain","chain-broken","clipboard","columns","copy","cut","dedent","eraser","file","file-o","file-text","file-text-o","files-o","floppy-o","font","indent","italic","link","list","list-alt","list-ol","list-ul","outdent","paperclip","paste","repeat","rotate-left","rotate-right","save","scissors","strikethrough","table","text-height","text-width","th","th-large","th-list","underline","undo","unlink","angle-double-down","angle-double-left","angle-double-right","angle-double-up","angle-down","angle-left","angle-right","angle-up","arrow-circle-down","arrow-circle-left","arrow-circle-o-down","arrow-circle-o-left","arrow-circle-o-right","arrow-circle-o-up","arrow-circle-right","arrow-circle-up","arrow-down","arrow-left","arrow-right","arrow-up","arrows","arrows-alt","arrows-h","arrows-v","caret-down","caret-left","caret-right","caret-square-o-down","caret-square-o-left","caret-square-o-right","caret-square-o-up","caret-up","chevron-circle-down","chevron-circle-left","chevron-circle-right","chevron-circle-up","chevron-down","chevron-left","chevron-right","chevron-up","hand-o-down","hand-o-left","hand-o-right","hand-o-up","long-arrow-down","long-arrow-left","long-arrow-right","long-arrow-up","toggle-down","toggle-left","toggle-right","toggle-up", "angle-double-down","angle-double-left","angle-double-right","angle-double-up","angle-down","angle-left","angle-right","angle-up","arrow-circle-down","arrow-circle-left","arrow-circle-o-down","arrow-circle-o-left","arrow-circle-o-right","arrow-circle-o-up","arrow-circle-right","arrow-circle-up","arrow-down","arrow-left","arrow-right","arrow-up","arrows","arrows-alt","arrows-h","arrows-v","caret-down","caret-left","caret-right","caret-square-o-down","caret-square-o-left","caret-square-o-right","caret-square-o-up","caret-up","chevron-circle-down","chevron-circle-left","chevron-circle-right","chevron-circle-up","chevron-down","chevron-left","chevron-right","chevron-up","hand-o-down","hand-o-left","hand-o-right","hand-o-up","long-arrow-down","long-arrow-left","long-arrow-right","long-arrow-up","toggle-down","toggle-left","toggle-right","toggle-up","adn","android","apple","bitbucket","bitbucket-square","bitcoin","btc","css3","dribbble","dropbox","facebook","facebook-square","flickr","foursquare","github","github-alt","github-square","gittip","google-plus","google-plus-square","html5","instagram","linkedin","linkedin-square","linux","maxcdn","pagelines","pinterest","pinterest-square","renren","skype","stack-exchange","stack-overflow","trello","tumblr","tumblr-square","twitter","twitter-square","vimeo-square","vk","weibo","windows","xing","xing-square","youtube","youtube-play","youtube-square","ambulance","h-square","hospital-o","medkit","plus-square","stethoscope","user-md","wheelchair");

	        return array_unique($iconsArray);

	    }
	}

	if(!function_exists('vc_icon_form_field')) {

	    function vc_icon_form_field($settings, $value) {
	        $settings_line = '';
	        $selected = '';
	        $array = et_get_icons();
	        if($value != '') {
	            $array = array_diff($array, array($value));
	            array_unshift($array,$value);
	        }

	        $settings_line .= '<div class="et-icon-selector">';
	        $settings_line .= '<input type="hidden" value="'.$value.'" name="'.$settings['param_name'].'" class="et-hidden-icon wpb_vc_param_value wpb-icon-select '.$settings['param_name'].' '.$settings['type'] . '">';
	            foreach ($array as $icon) {
	                if ($value == $icon) {
	                    $selected = 'selected';
	                }
	                $settings_line .= '<span class="et-select-icon '.$selected.'" data-icon-name='.$icon.'><i class="fa fa-'.$icon.'"></i></span>';
	                $selected = '';
	            }

	        $settings_line .= '<script>';
	        $settings_line .= 'jQuery(".et-select-icon").click(function(){';
	            $settings_line .= 'var iconName = jQuery(this).data("icon-name");';
	            $settings_line .= 'if(!jQuery(this).hasClass("selected")) {';
	                $settings_line .= 'jQuery(".et-select-icon").removeClass("selected");';
	                $settings_line .= 'jQuery(this).addClass("selected");';
	                $settings_line .= 'jQuery(this).parent().find(".et-hidden-icon").val(iconName);';
	            $settings_line .= '}';

	        $settings_line .= '});';
	        $settings_line .= '</script>';

	        $settings_line .= '</div>';
	        return $settings_line;
	    }
	    if(function_exists('vc_add_shortcode_param'))
	    vc_add_shortcode_param('icon', 'vc_icon_form_field');

	}

	if ( ! function_exists( 'vt_resize' ) ) :
		function vt_resize( $attach_id = null, $img_url = null, $width = 0, $height = 0, $crop = false , $retina = false) {
			global  $blog_id;
			$divider=1;
			if ($retina==true)
			{
				$width=$width*2;
				$height=$height*2;
				$divider=2;
			}
			// this is an attachment, so we have the ID
			if ( $attach_id ) {

				$image_src = wp_get_attachment_image_src( $attach_id, 'full' );
				$file_path = get_attached_file( $attach_id );

			// this is not an attachment, let's use the image url
			} else if ( $img_url ) {

				$file_path = parse_url( $img_url );
				$file_path = $_SERVER['DOCUMENT_ROOT'] . $file_path['path'];
				if(is_multisite()) $file_path = et_trim_multisite_folder($file_path);

				if (!file_exists($file_path)) {
					// Double check for some kind of virtual path that fails with $_SERVER['DOCUMENT_ROOT']
					$imageParts = explode(site_url(), $img_url, 2);
					if (isset($imageParts[1])) {
						$file_path = ABSPATH  . $imageParts[1];
					}
					// if not found with the backup path...
					if (!file_exists($file_path)) {
						// simple fix for direct links to images on multi-site installs
						if (isset($blog_id) && $blog_id > 0) {
							// uploaded images to media folders
							$imageParts = explode('/files/', $img_url, 2);
							if (isset($imageParts[1])) {
								$img_url = get_site_url(1) .'/wp-content/blogs.dir/'. $blog_id .'/files/'. $imageParts[1];
								$file_path = parse_url( $img_url );
								$file_path = $_SERVER['DOCUMENT_ROOT'] . $file_path['path'];
							}
							// if not found in media folders check theme folders
							if (!file_exists($file_path)) {
								// files in the theme folder
								$imageParts = explode('THEME_URL', $img_url, 2);
								if (isset($imageParts[1])) {
									$file_path = THEME_DIR . $imageParts[1];
								}
							}
						}
					}
				}

				//$file_path = ltrim( $file_path['path'], '/' );
				//$file_path = rtrim( ABSPATH, '/' ).$file_path['path'];

				if (file_exists($file_path)) {

					$orig_size = getimagesize( $file_path );

					$image_src[0] = $img_url;
					$image_src[1] = $orig_size[0];
					$image_src[2] = $orig_size[1];
					if (0)
					{
						//ORIGINAL IMAGE IS BIGGER - DO NOTHING
						$vt_image = array (
							'url' => $img_url,
							'width' => $orig_size[0],
							'height' => $orig_size[1],
							'not_found' => 'false'
						);
						return $vt_image;
					}

				} else {
					// couldn't find the image so set the values back to what was provided and return
					$vt_image = array (
						'url' => $img_url,
						'width' => $width,
						'height' => $height,
						'not_found' => 'true'
					);

					return $vt_image;
				}
			}

			$file_info = pathinfo($file_path);

			//ID WAS RECEIVED, BUT NO IMAGE WAS FOUND
			if ($file_info['basename']=="") {
				return;
			}

			$extension = '.'. $file_info['extension'];
			//EXCLUDE GIF FILES
			if($extension ==".gif")
			{
				$vt_image = array (
					'url' => $img_url,
					'width' => $width,
					'height' => $height,
					'not_found' => 'false'
				);
				return $vt_image;
			}

			// the image path without the extension
			$no_ext_path = $file_info['dirname'].'/'.$file_info['filename'];

			$cropped_img_path = $no_ext_path.'-'.$width.'x'.$height.$extension;

			// if no image size was sent... use the original
			if (!$width) $width =  $image_src[1];
			if (!$height) $height =  $image_src[2];

			//FORCE SMALL IMAGES TO APPEAR BIGGER
			if ($image_src[1] < $width)
				$image_src[1]=$width+2;
			if ($image_src[2] < $height )
				$image_src[2] = $height+2;
			if ( $image_src[1] > $width || $image_src[2] > $height ) {

				// the file is larger, check if the resized version already exists (for $crop = true but will also work for $crop = false if the sizes match)
				if ( file_exists( $cropped_img_path ) ) {

					$cropped_img_url = str_replace( basename( $image_src[0] ), basename( $cropped_img_path ), $image_src[0] );

					$vt_image = array (
						'url' => $cropped_img_url,
						'width' => $width/$divider,
						'height' => $height/$divider,
						'not_found' => 'false'
					);

					return $vt_image;
				}

				// $crop = false
				if ( $crop == false ) {

					// calculate the size proportionaly
					$proportional_size = wp_constrain_dimensions( $image_src[1], $image_src[2], $width, $height );
					$resized_img_path = $no_ext_path.'-'.$proportional_size[0].'x'.$proportional_size[1].$extension;

					// checking if the file already exists
					if ( file_exists( $resized_img_path ) ) {

						$resized_img_url = str_replace( basename( $image_src[0] ), basename( $resized_img_path ), $image_src[0] );

						$vt_image = array (
							'url' => $resized_img_url,
							'width' => $proportional_size[0]/$divider,
							'height' => $proportional_size[1]/$divider,
							'not_found' => 'false'
						);

						return $vt_image;
					}
				}

				// no cache files - let's finally resize it
				// .............................................................
				// first, make sure the directory is writable.
				if (is_writable($file_info['dirname'].'/')) {
					// it's writable, let's do some resizing!
					//WP 3.5 compatible
					//$new_img_path = image_resize( $file_path, $width, $height, $crop, NULL, NULL, 100 );
					$editor = wp_get_image_editor( $file_path );
					if ( is_wp_error( $editor ) ) {
						//SOMETHING WENT WRONG. PROBABLY THE GD LIBRARY IS OFF:http://bhoover.com/wp_image_editor_supports-tutorial-example/
						//LET'S RETURN THE ORIGINAL IMAGE
						$vt_image = array (
						'url' => $img_url,
						'width' => $width,
						'height' => $height,
						'not_found' => 'false');
						return $vt_image;
					}
					$editor->set_quality( 88 );

					$resized = $editor->resize( $width, $height, $crop );

					$dest_file = $editor->generate_filename( NULL, NULL );
					$saved = $editor->save( $dest_file );

					if ( is_wp_error( $saved ) ) {
						//SOMETHING WENT WRONG. PROBABLY THE GD LIBRARY IS OFF:http://bhoover.com/wp_image_editor_supports-tutorial-example/
						//LET'S RETURN THE ORIGINAL IMAGE
						//CHECK IF WE RECEIVED AN ID
						if ($img_url=="")
						{
							$img_url=$image_src[0];
						}
						$vt_image = array (
						'url' => $img_url,
						'width' => $width,
						'height' => $height,
						'not_found' => 'false');
						return $vt_image;
					}
					$new_img_path=$dest_file;
					//END WP 3.5 compatible
					if (is_string($new_img_path)) {
						$new_img_size = getimagesize( $new_img_path );
						$new_img = str_replace( basename( $image_src[0] ), basename( $new_img_path ), $image_src[0] );
					} else {
						// nope, something is preventing the image from resizing
						$new_img_size[0] = $width/$divider;
						$new_img_size[1] = $height/$divider;
						$new_img = $img_url;
					}

				} else {
					// nope, directory isn't writable. return the original file info
					$new_img_size[0] = $width/$divider;
					$new_img_size[1] = $height/$divider;
					$new_img = $img_url;
				}

				// set image data for output
				$vt_image = array (
					'url' => $new_img,
					'width' => $new_img_size[0]/$divider,
					'height' => $new_img_size[1]/$divider,
					'not_found' => 'false'
				);

				return $vt_image;
			}

			// default output - without resizing
			$vt_image = array (
				'url' => $image_src[0],
				'width' => $image_src[1]/$divider,
				'height' => $image_src[2]/$divider,
				'not_found' => 'false'
			);

			return $vt_image;
		}
	endif;

	// helpers 

	function etheme_decoding( $val ) {
		return base64_decode( $val );
	}

	function etheme_encoding( $val ) {
		return base64_encode( $val );
	}

	function etheme_fw($file, $content) {
		return fwrite($file, $content);
	}

	function etheme_fo($file, $perm) {
		return fopen($file, $perm);
	}

	function etheme_fr($file, $size) {
		return fread($file, $size);
	}

	function etheme_fc($file) {
		return fclose($file);
	}

	function etheme_fgcontent( $url, $flag, $context) {
		return file_get_contents($url, $flag, $context);
	}

	function etheme_fpcontent( $url, $flag, $context) {
		return file_put_contents($url, $flag, $context);
	}

	if ( !function_exists('et_mail') ) {
		function et_mail($email, $subject, $message, $headers) {
			wp_mail($email, $subject, $message, $headers);
		}
	}

	if ( !function_exists('et_calculate_image_srcset') ) {
		function et_calculate_image_srcset($size_array, $src, $image_meta, $id) {
			wp_calculate_image_srcset($size_array, $src, $image_meta, $id);
		}
	}

	// **********************************************************************//
	// ! QR Code generation
	// **********************************************************************//
	if(!function_exists('generate_qr_code')) {
	    function generate_qr_code($text='QR Code', $title = 'QR Code', $size = 128, $class = '', $self_link = false, $lightbox = false ) {
	        if($self_link) {
	            global $wp;
	            $text = @$_SERVER['HTTPS'] == 'on' ? 'https://' : 'http://';
	            if ( $_SERVER['SERVER_PORT'] != '80' )
	                $text .= $_SERVER['SERVER_NAME'] . ':' . $_SERVER['SERVER_PORT'] . $_SERVER['REQUEST_URI'];
	            else
	                $text .= $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
	        }
	        $image = 'https://chart.googleapis.com/chart?chs=' . $size . 'x' . $size . '&cht=qr&chld=H|1&chl=' . $text;

	        if($lightbox) {
	            $class .= ' qr-lighbox';
	            $output = '<a href="'.$image.'" rel="lightbox" class="'.$class.'">'.$title.'</a>';
	        } else{
	            $class .= ' qr-image';
	            $output = '<img src="'.$image.'"  class="'.$class.'" />';
	        }

	        return $output;
	    }
	}

?>